<?php
// Database configuration
$host = 'localhost';
$user = 'root';
$pass = '';
$dbname = 'license_system';

try {
    // Create connection without database
    $pdo = new PDO("mysql:host=$host", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Create database
    $pdo->exec("DROP DATABASE IF EXISTS `$dbname`");
    $pdo->exec("CREATE DATABASE `$dbname`");
    $pdo->exec("USE `$dbname`");
    
    // Create admin_users table
    $pdo->exec("CREATE TABLE admin_users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        username VARCHAR(50) NOT NULL UNIQUE,
        password VARCHAR(255) NOT NULL,
        email VARCHAR(100) NOT NULL UNIQUE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");
    
    // Create licenses table
    $pdo->exec("CREATE TABLE licenses (
        id INT AUTO_INCREMENT PRIMARY KEY,
        license_key VARCHAR(255) NOT NULL UNIQUE,
        domain VARCHAR(255) NOT NULL,
        status ENUM('active', 'inactive', 'expired') DEFAULT 'active',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        expires_at TIMESTAMP NULL,
        last_check TIMESTAMP NULL
    )");
    
    // Create license_logs table
    $pdo->exec("CREATE TABLE license_logs (
        id INT AUTO_INCREMENT PRIMARY KEY,
        license_id INT,
        action VARCHAR(50) NOT NULL,
        ip_address VARCHAR(45),
        user_agent TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (license_id) REFERENCES licenses(id)
    )");
    
    // Insert default admin user
    $password = password_hash('admin123', PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("INSERT INTO admin_users (username, password, email) VALUES (?, ?, ?)");
    $stmt->execute(['admin', $password, 'admin@example.com']);
    
    echo "<h2>Setup Completed Successfully!</h2>";
    echo "<p>Database and tables have been created.</p>";
    echo "<p>Default admin credentials:</p>";
    echo "<ul>";
    echo "<li>Username: admin</li>";
    echo "<li>Password: admin123</li>";
    echo "</ul>";
    echo "<p><a href='admin/login.php' style='color: blue; text-decoration: underline;'>Click here to go to login page</a></p>";
    
} catch(PDOException $e) {
    die("Setup failed: " . $e->getMessage());
}
?> 